const { time } = require("@nomicfoundation/hardhat-network-helpers");
const { anyValue } = require("@nomicfoundation/hardhat-chai-matchers/withArgs");
const { expect } = require("chai");
const IERC20 = "@openzeppelin/contracts/token/ERC20/IERC20.sol:IERC20";

/*
  Note requires a mainnet fork to interact with lido/curve
  npx hardhat node --fork https://eth-mainnet.alchemyapi.io/v2/YOURAPIKEY
*/

describe("RastaKitty98", function () {
  let ras,pool,owner,user1,oneETH;
  

  it("Deployment", async function () {
    [owner,user1] = await ethers.getSigners();
    oneETH = ethers.utils.parseEther('1');
    const RAS = await hre.ethers.getContractFactory("RastaKitty98");
    ras = await RAS.deploy();
    await ras.deployed();
    expect(await ras.name()).to.be.oneOf(['TESTKITTY','RastaKitty']);
  });

  it("Add Liquidity", async function () {
    await ras.addLiquidity();
    const balance = await ras.balanceOf(ras.address);
    expect(balance).to.lt(10000);
  });

  it("Revert On Second addLiquidity", async function () {
    await expect(ras.addLiquidity()).to.be.reverted;
  });

  it("Renounce Ownership", async function () {
    await ras.renounceOwnership();
    const owner = await ras.owner();
    expect(owner).to.eq('0x0000000000000000000000000000000000000000');
  });

  it("Marketing Balance", async function () {
    const balance = await ras.balanceOf('0x8006b1eef7884b21D4fE4De9Cb0EBB0cB56B5e4F');
    const marketingSupply = ethers.utils.parseEther('5000000');
    expect(balance).to.eq(marketingSupply);
  });

  it("Team Balance", async function () {
    const balance = await ras.balanceOf('0xaA63F6b94856A2f32333DfD116626efcCde74261');
    const teamSupply = ethers.utils.parseEther('5000000');
    expect(balance).to.eq(teamSupply);
  });

  it("Check Liquidity Pool", async function () {
    const poolAddress = await ras.pool();
    const poolAbi = ["function fee() external view returns (uint24)"];
    pool = await hre.ethers.getContractAt(poolAbi, poolAddress);
    const fee = await pool.fee();
    expect(fee).to.eq(3000);
  });


  it("Deploy Multiple Times", async function () {
    // This is to check the fixOrdering works depending on deployment address
    for (let i = 0; i < 10; i++) {
      const RAS = await hre.ethers.getContractFactory("RastaKitty");
      const ras2 = await RAS.deploy();
      await ras2.deployed();
      await ras2.addLiquidity();
      const balance = await ras2.balanceOf(ras2.address);
      expect(balance).to.lt(10000);
    }
  });

});
