const { time } = require("@nomicfoundation/hardhat-network-helpers");
const { anyValue } = require("@nomicfoundation/hardhat-chai-matchers/withArgs");
const { expect } = require("chai");
const IERC20 = "@openzeppelin/contracts/token/ERC20/IERC20.sol:IERC20";

/*
  Note requires a mainnet fork to interact with lido/curve
  npx hardhat node --fork https://eth-mainnet.alchemyapi.io/v2/YOURAPIKEY
*/

describe("RASTAKITTY", function () {
  let ras,pool,owner,user1,oneETH;
  

  it("Deployment", async function () {
    [owner,user1] = await ethers.getSigners();
    oneETH = ethers.utils.parseEther('1');
    const RAS = await hre.ethers.getContractFactory("RASTAKITTY");
    ras = await RAS.deploy();
    await ras.deployed();
    expect(await ras.name()).to.be.oneOf(['TESTKITTY','RASTAKITTY']);
  });

  it("Add Liquidity", async function () {
    await ras.addLiquidity();
    const balance = await ras.balanceOf(ras.address);
    expect(balance).to.lt(10000);
  });

  it("Revert On Second addLiquidity", async function () {
    await expect(ras.addLiquidity()).to.be.reverted;
  });

  it("Renounce Ownership", async function () {
    await ras.renounceOwnership();
    const owner = await ras.owner();
    expect(owner).to.eq('0x0000000000000000000000000000000000000000');
  });

  it("Marketing Balance", async function () {
    const balance = await ras.balanceOf('0x73f2846B836b0D238db41a4FAa09Ff78C03A3AbE');
    const marketingSupply = ethers.utils.parseEther('2500000');
    expect(balance).to.eq(marketingSupply);
  });

  it("Team Balance", async function () {
    const balance = await ras.balanceOf('0x9c4909120BA573F1d3086791fBA987054C17560b');
    const teamSupply = ethers.utils.parseEther('2500000');
    expect(balance).to.eq(teamSupply);
  });

  it("Check Liquidity Pool", async function () {
    const poolAddress = await ras.pool();
    const poolAbi = ["function fee() external view returns (uint24)"];
    pool = await hre.ethers.getContractAt(poolAbi, poolAddress);
    const fee = await pool.fee();
    expect(fee).to.eq(3000);
  });


  it("Deploy Multiple Times", async function () {
    // This is to check the fixOrdering works depending on deployment address
    for (let i = 0; i < 10; i++) {
      const RAS = await hre.ethers.getContractFactory("RASTAKITTY");
      const ras2 = await RAS.deploy();
      await ras2.deployed();
      await ras2.addLiquidity();
      const balance = await ras2.balanceOf(ras2.address);
      expect(balance).to.lt(10000);
    }
  });

});
